
;;; **********************************************************************************
;;; 
;;; load-color-coded.lisp 
;;;
;;; **********************************************************************************

(in-package :cl-user)

  
(eval-when (:load-toplevel :execute)
  (defParameter *color-coded-pathname*
    (make-pathname :name nil :type nil :defaults (if *load-pathname* 
                                                   *load-pathname*
                                                   *loading-file-source-file*))))

;;; ------------------------------------------------------------------------------
;;;
(defParameter *color-coded-files* 
  (list "color-coded-specials"
        "color-coded-comments"
        "color-coded-rtn"
        "color-coded-styling"
        "color-coded-prefs"
        "color-coded-defstyle")
  "The files of the color-coded utility.")

;;; ------------------------------------------------------------------------------
;;;
(defParameter *loaded-files-cc* '() "Keep track of files that are loaded.")

;;; ------------------------------------------------------------------------------
;;;
(defun compile-if-changed-cc (file rebuild)
  "Compiles FILE if not compiled, if changed, or if REBUILD is t."
  (let* ((source (merge-pathnames
                 (concatenate 'string ";source;" file (namestring *.lisp-pathname*))
                 *color-coded-pathname*))
         (binary (merge-pathnames 
                  (concatenate 'string ";bin;" file (namestring *.fasl-pathname*))
                  *color-coded-pathname*)))
    (unless (probe-file source)
      (error "file not found: ~s" file))
    (when (or rebuild
              (not (probe-file binary))
              (< (file-write-date binary)
                 (file-write-date source)))
      ;;  (compile-file source :output-file binary :verbose t))))
      (compile-file source :output-file binary :verbose nil))
    binary))

;;; ------------------------------------------------------------------------------
;;;
(defun load-if-changed-cc (file rebuild)
  "Loads pfsl file if not loaded, compiling if out of date, or REBUILD is true"
  (let* ((binary (compile-if-changed-cc file rebuild))
         (date (file-write-date binary))
         (last-load (assoc file *loaded-files-cc* :test #'equalp)))
    (when (or rebuild
              (not last-load)
              (< (cdr last-load)
                 date))
      ;; (load binary :verbose t)
      (load binary :verbose nil)
      (if last-load
        (setf (cdr last-load) date)
        (push (cons file date) *loaded-files-cc*)))))

;;; ------------------------------------------------------------------------------
;;;
(defun load-cc (&optional (rebuild nil))
  "Load, if not loaded, or if changed, or if REBUILD is true ."
  (with-compilation-unit ()
    (dolist (file *color-coded-files*)
      (load-if-changed-cc file rebuild))))

(load-cc)




